#include<uart.h>
#include<p30fxxxx.h>

/* UART2 is defined in following devices */
#if defined(__dsPIC30F3011__) || defined(__dsPIC30F4011__) || defined(__dsPIC30F6010__) || \
    defined(__dsPIC30F3013__) || defined(__dsPIC30F3014__) || defined(__dsPIC30F5011__)	|| \
    defined(__dsPIC30F6011__) || defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) || \
    defined(__dsPIC30F6013__) || defined(__dsPIC30F6014__) || defined(__dsPIC30F4013__)

/*********************************************************************
* Function Name     : CloseUART2
* Description       : This function disables the UART and clears the 
*                     interrupt enable and flag bits
* Parameters        : None
* Return Value      : None
*********************************************************************/

void CloseUART2(void)
{  
    U2MODEbits.UARTEN = 0;
	
    IEC1bits.U2RXIE = 0;
    IEC1bits.U2TXIE = 0;
	
    IFS1bits.U2RXIF = 0;
    IFS1bits.U2TXIF = 0;
}

#endif
